#!/usr/bin/python
# -*- coding:utf-8 -*-
import os
import sys
import stat
import time
import tarfile
import shutil
import hashlib
import subprocess

UNTAR_DEPLOY_ERR = 2
UNTAR_OEM_ERR = 3

def CleanDir(Dir):
    if os.path.isdir(Dir):
        paths = os.listdir(Dir)
        for path in paths:
            filePath = os.path.join(Dir, path)
            if os.path.isfile(filePath):
                try:
                    os.remove(filePath)
                except os.error:
                    autoRun.exception("remove %s error." %filePath)  # 引入logging
            elif os.path.isdir(filePath):
                shutil.rmtree(filePath,True)
    return True
def sha256sum(fname):
    """
    计算文件的sha256值
    """

    def read_chunks(fh):
        fh.seek(0)
        chunk = fh.read(8096)
        while chunk:
            yield chunk
            chunk = fh.read(8096)
        else:  # 最后要将游标放回文件开头
            fh.seek(0)
    m = hashlib.sha256()
    if isinstance(fname, basestring) \
        and os.path.exists(fname):
        fh = open(fname, "rb")
        try:
            for chunk in read_chunks(fh):
                m.update(chunk)
        finally:
            fh.close()
    # 上传的文件缓存 或 已打开的文件流
    elif fname.__class__.__name__ in ["StringIO", "StringO"] \
        or isinstance(fname, file):
        for chunk in read_chunks(fname):
            m.update(chunk)
    else:
        return ""
    return m.hexdigest()


def tar(fname):
    t = tarfile.open(fname + ".tar.gz", "w:gz")
    for root, dir, files in os.walk(fname):
        for file in files:
            fullpath = os.path.join(root, file)
            t.add(fullpath)
    t.close()
    return


def untar(fname, dirs):
    max_size_gb = 10
    max_files = 1000
    max_size_bytes = max_size_gb * 1024 * 1024 * 1024
    with tarfile.open(fname) as t:
        first_level_files = [member for member in t.getmembers() if '/' not in member.name.strip('/')]       
        # 1. 检查第一层文件总大小是否超过 10 GB
        total_size = sum(member.size for member in first_level_files)
        if total_size > max_size_bytes:  # 10GB = 10 * 1024 * 1024 * 1024 bytes
            return False
        # 2. 检查第一层文件个数是否超过 1000 个
        if len(first_level_files) > max_files:
            return False
        # 3. 条件全部满足，执行解压
        t.extractall(path = dirs)
        return True


def main(context,oem_path,app_path,create_path):	
    logger = context.get('logger')
    app_path_split = app_path.split('\\')
    verfile = app_path_split[len(app_path_split) - 1]

    verfile = verfile[:-7]

    # 解压
    homedir = os.getcwd()

    if(not os.path.exists(homedir + '\\test')):
        os.mkdir(homedir + '\\test')

    if((verfile.find("7.1") != -1) and (verfile.find("update") != -1)):
        destpath = homedir + '\\test\\' + verfile  + '\\app\\'
    else:
        destpath = homedir + '\\test\\' + verfile + '\\'

    if (os.path.exists(destpath)):
        os.chmod(destpath, stat.S_IRWXU|stat.S_IRWXG|stat.S_IRWXO)
        CleanDir(destpath)
        os.rmdir(destpath)

    ret = untar(app_path, homedir + '\\test\\')
    if ret is False:
        return (False, UNTAR_DEPLOY_ERR)
    # oem包放在解压后的目录里面
    # 工具生成的包是oem.tgz,里面没有oem目录，把tgz包解压，然后重新压缩成oem.tar.gz
    if (not os.path.exists(homedir + '\\test\\oem')):
        os.mkdir(homedir + '\\test\\oem')
    ret = untar(oem_path, homedir + '\\test\\oem\\')
    if ret is False:
        return (False, UNTAR_OEM_ERR)
    os.chdir(homedir + '\\test\\')
    # 压缩
    tar('oem')
    shutil.copy(homedir + '\\test\\oem.tar.gz', destpath)

    os.chdir(destpath)

    if(os.path.exists('./sha256')):
        if(os.path.exists('./md5')):
            os.remove('./md5')

        if(os.path.exists('./sw_md5')):
            os.remove('./sw_md5')

        if(os.path.exists('./sha256')):
            os.remove('./sha256')

        if(os.path.exists('./rsa_sha256')):
            os.remove('./rsa_sha256')

        file = open('sha256', 'a')
        for i in os.listdir(destpath):
            if os.path.isfile(os.path.join(destpath,i)):
                if (-1 != i.find('md5')) or (-1 != i.find('sw_md5')) or (-1 != i.find('sha256')):
                    continue
                sharesult = sha256sum(i)
                content = sharesult + '  ' + i + '\n'
                file.write(content)
        file.close()

        file = open('temp_sha256', 'a')
        sha = sha256sum('sha256')
        content = sha + '  sha256'
        file.write(content)
        file.close()

        list1 = "openssl rsautl -sign -in temp_sha256 -inkey \"%s\"\\packages\\products\\mass\\V300R006C00\script\\pkg_private_key.pem -out rsa_sha256" % homedir
        child1 = subprocess.Popen(list1.split(), shell=False, stdout=subprocess.PIPE)
        out1 = child1.communicate()
        aa = child1.wait()
        logger.info("The result is %s" % aa)
        if(0 != aa):
            list2 = "C:\\OpenSSL-Win32\\bin\\openssl.exe rsautl -sign -in temp_sha256 -inkey \"%s\"\\packages\\products\\mass\\V300R006C00\script\\pkg_private_key.pem -out rsa_sha256" % homedir
            child2 = subprocess.Popen(list2.split(), shell=False, stdout=subprocess.PIPE)
            out2 = child2.communicate()
            aa2 = child2.wait()
            logger.info("The result is %s" % aa2)
            if(0 != aa2):
                list3 = "C:\\OpenSSL-Win64\\bin\\openssl.exe rsautl -sign -in temp_sha256 -inkey \"%s\"\\packages\\products\\mass\\V300R006C00\script\\pkg_private_key.pem -out rsa_sha256" % homedir
                child3 = subprocess.Popen(list3.split(), shell=False, stdout=subprocess.PIPE)
                out3 = child3.communicate()
                aa3 = child3.wait()
                logger.info("The result is %s" % aa3)
                if(0 != aa3):
                    return (False, '')

        if(os.path.exists('./temp_sha256')):
            os.remove('./temp_sha256')

    os.chdir(homedir + '\\test\\')

    # 压缩
    tar(verfile)
    CleanDir(destpath)
    os.rmdir(destpath)

    shutil.copy(verfile + '.tar.gz', create_path)

    os.chdir(homedir)
    CleanDir(homedir + '\\test\\')
    os.rmdir(homedir + '\\test\\')
    return (True, '')


def execute(context):
    lang = context.get('lan')
    oemPath = context.get('oemPath')
    verPath = context.get('originalPkgPath')
    createPath = context.get('createPath')

    if(not os.path.exists(verPath)):

        if lang == 'en':
            msg = 'Executed fail. Please make sure OceanStor 9000 product package exists in selected director'
        else:
            msg = u'执行失败，请确认在选择的路径下存在OceanStor 9000产品软件包。'
        return (False, msg)

    ret, opc = main(context, oemPath, verPath, createPath)
    if ret is False and opc == UNTAR_DEPLOY_ERR:
        if lang == 'en':
            msg = 'Unzip failed.Deploy packages pose security risks.'
        else:
            msg = u'解压失败，导入的部署包存在安全隐患。'
        return (False, msg)
    elif ret is False and opc == UNTAR_OEM_ERR:
        if lang == 'en':
            msg = 'Unzip failed.OEM packages pose security risks.'
        else:
            msg = u'解压失败，导入的OEM包存在安全隐患。'
        return (False, msg)
    elif not ret:
        if lang == 'en':
            msg = 'Executed fail. Please install openssl,and its version shoude be newer than 0.9.8.'
        else:
            msg = u'执行失败，请安装openssl组件（0.9.8以上版本）。'
        return (False, msg)

    return (True,'')

